<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drug_related_tag', function (Blueprint $table) {
            $table->comment('药品和标签关联表');

            $table->bigIncrements('id');
            $table->bigInteger('drug_id')->comment('药品ID');
            $table->bigInteger('tag_id')->comment('标签ID');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drug_related_tag');
    }
};
