<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prescription_log', function (Blueprint $table) {
            $table->comment('处方日志');

            $table->bigIncrements('id');
            $table->bigInteger('pharmacy_id')->comment('药店ID');
            $table->string('pharmacy_name', 64)->comment('药店名称');
            $table->text('log_info')->comment('日志描述');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prescription_log');
    }
};
