<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('doctor_correction', function (Blueprint $table) {
            $table->comment('医师');

            $table->bigIncrements('id');
            $table->integer('doctor_id')->comment('医师表ID');
            $table->string('doctor_name', 32)->comment('医师姓名');
            $table->tinyInteger('is_handle')->comment('是否处理[0=待处理,1=已处理]');
            $table->text('content')->comment('纠错内容');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('doctor_correction');
    }
};
