<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patient', function (Blueprint $table) {
            $table->comment('问诊人');

            $table->bigIncrements('id');
            $table->string('name', 32)->comment('姓名');
            $table->tinyInteger('gender')->default(0)->comment('性别。[1=男性,2=女性,0=未知]');
            $table->string('id_card', 18)->nullable()->index('idx_idcard')->comment('身份证号');
            $table->string('mobile', 11)->index('idx_mobile')->comment('手机号');
            $table->bigInteger('user_id')->nullable()->index('idx_userid')->comment('用户表ID。用户添加问诊人才有值');
            $table->bigInteger('pharmacy_id')->nullable()->index('idx_pharmacyid')->comment('药店表ID。药店添加问诊人猜有值');
            $table->boolean('is_default')->default(0)->comment('默认问诊人,用户添加的才需要设置[0=否,1=是]');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patient');
    }
};
