<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drug', function (Blueprint $table) {
            $table->comment('药品');

            $table->bigIncrements('id');
            $table->string('name', 64)->index('idx_name')->comment('药品名称');
            $table->string('code', 64)->index('idx_code')->comment('简码');
            $table->string('standard_code', 64)->index('idx_standardcode')->comment('本位码');
            $table->string('unit', 20)->nullable()->comment('单位');
            $table->string('spec', 128)->comment('包装规格');
            $table->string('dosage_form', 128)->comment('剂型');
            $table->string('factory', 128)->index('idx_factory')->comment('生产厂家');
            $table->string('approval_no', 64)->comment('批准文号');
            $table->integer('limit_buy_7')->default(0)->comment('7天内限购数量');
            $table->boolean('is_rx')->default(false)->comment('是否处方药');
            $table->boolean('is_si')->default(false)->comment('是否医保药品');
            $table->integer('product_id')->default(0)->comment('君元ID');
            $table->string('preparation_pec')->default('')->comment('制剂规格');
            $table->string('product_name', 64)->default('')->comment('商品名');
            $table->string('mnemonic', 64)->default('')->comment('助记码');
            $table->string('category_code', 32)->default('')->comment('分类码');
            $table->string('category_name', 32)->default('')->comment('分类名称');
            $table->boolean('is_foreign')->default(false)->comment('是否进口药');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drug');
    }
};
