<?php
namespace App\Services;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;


class ExternalService {
    private $clientId;
    private $clientSecret;
    private $baseUrl;

    public function __construct($clientId, $clientSecret, $baseUrl) {
        $this->clientId = $clientId;
        $this->clientSecret = $clientSecret;
        $this->baseUrl = $baseUrl;
    }

    /**
     * 生成签名
     */
    private function generateSign($timeStamp) {
        return strtoupper(md5($this->clientId . $timeStamp . $this->clientSecret));
    }

    /**
     * 发送请求
     */
    private function sendRequest($endpoint, $data) {
        $url = $this->baseUrl . $endpoint;
        print_r($url . "\n");
        $data_string = json_encode($data);
        print_r($data_string . "\n");
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json;charset=utf-8',
            'Accept: application/json',
            'Content-Length: ' . strlen($data_string))
        );
        $result = curl_exec($ch);
        curl_close($ch);
        // print_r($data_string . "\n");
        // print_r($result . "\n");
        return json_decode($result, true);
    }

    

    /**
     * 挂号接口
     */
    public function registerPatient($params) {
        $timeStamp = time() * 1000; // 当前时间戳（毫秒）
        $sign = $this->generateSign($timeStamp);

        $params['clientId'] = $this->clientId;
        $params['timeStamp'] = $timeStamp;
        $params['sign'] = $sign;

        return $this->sendRequest('/v1_0/ehospital/openapi/kz/tzt/registerRecordPage', $params);
    }

    /**
     * 就诊记录接口
     */
    public function getMedicalRecord($params) {
        $timeStamp = time() * 1000; // 当前时间戳（毫秒）
        $sign = $this->generateSign($timeStamp);

        $params['clientId'] = $this->clientId;
        $params['timeStamp'] = $timeStamp;
        $params['sign'] = $sign;

        return $this->sendRequest('/v1_0/ehospital/openapi/kz/tzt/medicalRecordPage', $params);
    }

    /**
     * 处方开立（西药）接口
     */
    public function createPrescriptionWm($params) {
        $timeStamp = time() * 1000; // 当前时间戳（毫秒）
        $sign = $this->generateSign($timeStamp);

        $params['clientId'] = $this->clientId;
        $params['timeStamp'] = $timeStamp;
        $params['sign'] = $sign;

        return $this->sendRequest('/v1_0/ehospital/openapi/kz/tzt/prescriptionWmPage', $params);
    }

    /**
     * 处方开立（中药）接口
     */
    public function createPrescriptionCm($params) {
        $timeStamp = time() * 1000; // 当前时间戳（毫秒）
        $sign = $this->generateSign($timeStamp);

        $params['clientId'] = $this->clientId;
        $params['timeStamp'] = $timeStamp;
        $params['sign'] = $sign;

        return $this->sendRequest('/v1_0/ehospital/openapi/kz/tzt/prescriptionCmPage', $params);
    }
}

// print_r("执行开始...\n");
// // 使用方法
// $eHospitalApi = new ExternalService('jymd_15700159057_test', 'heU0zM9OrLrK0JehxiAXlPd3L48HHmcA', 'https://ehospital-openapi-test.sq580.com');
// $response = $eHospitalApi->getMedicalRecord([
//     // 根据文档填写必要的参数
//     "beginTime"=>"1732982400000",
//     "endTime"=>"1859212800000",
//     "pageNum"=>1,
//     "pageSize"=>20,
// ]);
// print_r($response);
// print_r("执行结束...\n");