<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PrescriptionLogModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'prescription_log';

    public function setPharmacyIdAttribute($pharmacyId)
    {
        $this->attributes['pharmacy_id'] = $pharmacyId;
        $pharmacy_name = PharmacyModel::find($pharmacyId)->name;
        $this->attributes['pharmacy_name'] = $pharmacy_name;
    }
}
