<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

// 药店
class PharmacyModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacy';

    // 平台启用店铺状态状态[0=启用,1=禁用]
    const STATUS_FALSE = 0;

    const STATUS_TRUE = 1;

    // 平台启用店铺状态状态-文字映射
    const STATUS_MAP = [
        self::STATUS_FALSE => '禁用',
        self::STATUS_TRUE => '启用',
    ];

    // 开店状态[0=闭店,1=开店]
    const IS_OPEN_FALSE = 0;

    const IS_OPEN_TRUE = 1;

    // 是否问题是否通用通用-文字映射
    const IS_OPEN_MAP = [
        self::IS_OPEN_FALSE => '闭店',
        self::IS_OPEN_TRUE => '开店',
    ];

    // 是否默认-颜色映射
    const IS_OPEN_MAP_COLOR = [
        self::IS_OPEN_FALSE => 'danger',
        self::IS_OPEN_TRUE => 'success',
    ];

    // 自动审方[0=否,1=是]
    const IS_AUTO_FALSE = 0;

    const IS_AUTO_TRUE = 1;

    // 自动审方-文字映射
    const IS_AUTO_MAP = [
        self::IS_AUTO_FALSE => '否',
        self::IS_AUTO_TRUE => '是',
    ];

    // 自动审方-颜色映射
    const IS_AUTO_MAP_COLOR = [
        self::IS_AUTO_FALSE => 'gray',
        self::IS_AUTO_TRUE => 'success',
    ];


    // 开启医保开方[0=否,1=是]
    const IS_YB_OPEN_FALSE = 0;

    const IS_YB_OPEN_TRUE = 1;

    // 是否问题是否通用通用-文字映射
    const IS_YB_OPEN_MAP = [
        self::IS_YB_OPEN_FALSE => '否',
        self::IS_YB_OPEN_TRUE => '是',
    ];


    // 药店所属于的用户,一对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // 药店关联的药师,一对多
    public function pharmacist()
    {
        return $this->hasMany(PharmacistModel::class, 'pharmacist_id', 'id');
    }

    // 药店关联的问诊人,一对多
    public function patient()
    {
        return $this->hasMany(PatientModel::class, 'patient_id', 'id');
    }

    public function getDrugBizLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getBusinessLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getFoodBizLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getMedDeviceBizLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getDrugInfoServiceCertAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPrePackagedFoodAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }
}
