<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;

class PharmacyCorrectionModel extends Model
{
    use HasDateTimeFormatter;

    protected $table = 'pharmacy_correction';

    // 是否处理[0=待处理,1=已处理]
    const IS_HANDLE_FALSE = 0;

    const IS_HANDLE_TRUE = 1;

    // 是否处理-文字映射
    const IS_HANDLE_MAP = [
        self::IS_HANDLE_FALSE => '待处理',
        self::IS_HANDLE_TRUE => '已处理',
    ];
}
