<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DosageModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'dosage';

    // 关联药店
    public function pharmacy()
    {
        return $this->belongsTo(PharmacyModel::class, 'pharmacy_id', 'id');
    }
}
