<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{

    protected $commands = [
        \App\Console\Commands\Medical::class,
        \App\Console\Commands\TestCommand::class,
        \App\Console\Commands\WmPrescription::class,
        \App\Console\Commands\CmPrescription::class,
    ];
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        // $schedule->command('mohe:prescription')->everyMinute();
        //$schedule->command('mohe:test')->everyMinute();
        $schedule->command('medical:init')->daily(); 
        $schedule->command('cm-prescription:init')->daily();
        $schedule->command('wm-prescription:init')->daily();
    }
    

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
