<?php

namespace App\Console\Commands;


use App\Models\MedicalModel;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Services\ExternalService;
use Carbon\Carbon;

class Medical extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'medical:init {timestamp_str?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '同步问诊信息';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('问诊同步开始...');
        $timestamp_str = $this->argument('timestamp_str') ?? '';
        // 如果 timestamp_str 为空，则判断是否是当月第一天，决定取哪个月的第一天
        if (empty($timestamp_str)) {
            $now = Carbon::now();
            if ($now->isSameDay($now->copy()->startOfMonth())) {
                // 当前是当月第一天，获取上一个月的第一天
                $startOfMonth = $now->subMonth()->startOfMonth();
            } else {
                // 当前不是当月第一天，获取当前月的第一天
                $startOfMonth = $now->startOfMonth();
            }
            // 转换为毫秒时间戳
            $timestamp_str = $startOfMonth->timestamp * 1000;
        }
        // 计算结束时间：基于 timestamp_str 加上 30 天
        $beginTime = Carbon::createFromTimestampMs($timestamp_str); // 将毫秒时间戳转换为 Carbon 实例
        $endTime = $beginTime->copy()->addDays(31)->timestamp * 1000; // 加上 30 天并转换为毫秒时间戳
        // 输出时间戳以供调试
        $this->info("使用的开始时间戳: {$timestamp_str}");
        $this->info("使用的结束时间戳: {$endTime}");
        try {   
            $pageNum = 1;  // 初始页码
            $maxPage = 1;  // 默认最大页数为 1
            $baseParams = [
                // 根据文档填写必要的参数
                "beginTime"=>$timestamp_str,
                "endTime"=>$endTime,
                "pageNum"=>1,
                "pageSize"=>20,
            ];
            $eHospitalApi = new ExternalService(env('580_APP_KEY'), env('580_APP_SECRET'), env('580_DOMAIN'));
            while ($pageNum <= $maxPage) {
                // 设置当前页码参数
                $params = array_merge($baseParams, [
                    "pageNum" => $pageNum,
                ]);
                // 问诊
                $response = $eHospitalApi->getMedicalRecord($params);
                // 检查接口是否调用成功
                if (isset($response['err']) && $response['err'] === 0) {
                    echo "第 {$pageNum} 页查询成功。\n";

                    // 当前页数据
                    $response_data = $response['data']['list'];
                    Log::info('Medical-问诊信息:'.json_encode($response_data));
                    if( empty($response_data) ){
                        break;
                    }
                    # 处理数据存入到数据库，如果存在就更新否则就新增
                    foreach ($response_data as $item) {
                        // $this->info('问诊====>：'. json_encode($item));
                        // break;
                        $medical = MedicalModel::where('visitNo', $item['visitNo'])->first();
                        if($medical){
                            $this->info('更新问诊：'. $item['visitNo']);
                            // 基本信息
                            $medical->idcardTypeCode = $item['idcardTypeCode'] ?? null; // 患者就诊卡证类型
                            $medical->idcardNo = $item['idcardNo'] ?? null; // 患者就诊卡证号码
                            $medical->name = $item['name'] ?? null; // 姓名
                            $medical->genderCode = $item['genderCode'] ?? null; // 性别代码
                            $medical->birthdate = $item['birthdate'] ?? null; // 出生日期

                            // 监护人信息（互联网患者年龄小于6岁时必填）
                            $medical->guardName = $item['guardName'] ?? null; // 监护人姓名
                            $medical->guardIdcardNo = $item['guardIdcardNo'] ?? null; // 监护人身份证号码

                            // 主诉和症状
                            $medical->subjComplaint = $item['subjComplaint'] ?? null; // 主诉记录
                            $medical->mainSymptoms = $item['mainSymptoms'] ?? null; // 主要监测症状代码组合

                            // 病史描述
                            $medical->prexHx = $item['prexHx'] ?? null; // 病史描述
                            $medical->prevHist = $item['prevHist'] ?? null; // 现病史
                            $medical->pastHist = $item['pastHist'] ?? null; // 既往史
                            $medical->alleHist = $item['alleHist'] ?? null; // 过敏史

                            // 中医诊断
                            $medical->tcmDdCode = $item['tcmDdCode'] ?? null; // 中医疾病诊断代码
                            $medical->tcmDdName = $item['tcmDdName'] ?? null; // 中医疾病诊断名称
                            $medical->tcmSdCode = $item['tcmSdCode'] ?? null; // 中医证候诊断代码
                            $medical->tcmSdName = $item['tcmSdName'] ?? null; // 中医证候诊断名称

                            // 西医诊断
                            $medical->mdDisCode = $item['mdDisCode'] ?? null; // 西医诊断疾病代码
                            $medical->mdDisName = $item['mdDisName'] ?? null; // 西医诊断疾病名称

                            // 其他诊断
                            $medical->disCode1 = $item['disCode1'] ?? null; // 其他诊断①疾病代码
                            $medical->disName1 = $item['disName1'] ?? null; // 其他诊断①疾病名称
                            $medical->disCode2 = $item['disCode2'] ?? null; // 其他诊断②疾病代码
                            $medical->disName2 = $item['disName2'] ?? null; // 其他诊断②疾病名称

                            // 医生描述
                            $medical->disDescription = $item['disDescription'] ?? null; // 医生对门诊诊断的描述
                            $medical->treatMeas = $item['treatMeas'] ?? null; // 处理措施

                            // 就诊医疗机构信息
                            $medical->unifiedOrgCode = $item['unifiedOrgCode'] ?? null; // 就诊医疗机构编码
                            $medical->orgName = $item['orgName'] ?? null; // 就诊医疗机构名称

                            // 就诊科室信息
                            $medical->deptCode = $item['deptCode'] ?? null; // 就诊科室编码
                            $medical->deptName = $item['deptName'] ?? null; // 就诊科室名称
                            $medical->deptClassCode = $item['deptClassCode'] ?? null; // 就诊科室对应诊疗科目编码
                            $medical->deptClassName = $item['deptClassName'] ?? null; // 就诊科室对应诊疗科目名称

                            // 就诊医师信息
                            $medical->doctIdcardNo = $item['doctIdcardNo'] ?? null; // 就诊医师身份证号
                            $medical->doctName = $item['doctName'] ?? null; // 就诊医师姓名

                            // 就诊时间
                            $medical->visitTimeStart = $item['visitTimeStart'] ?? null; // 就诊开始时间
                            $medical->visitTimeEnd = $item['visitTimeEnd'] ?? null; // 诊断结束时间

                            // 数字签名相关
                            $medical->doctCaSign = $item['doctCaSign'] ?? null; // 就诊医师电子签名
                            $medical->originalData = $item['originalData'] ?? null; // 数据原文
                            $medical->certificate = $item['certificate'] ?? null; // 数字证书

                            // 其他信息
                            $medical->reviewUrl = $item['reviewUrl'] ?? null; // 诊疗过程调阅地址
                            // 线下初诊记录（对象类型）
                            if (isset($item['firstVisitRecord'])) {
                                $medical->firstVisitRecord = json_encode($item['firstVisitRecord'], JSON_UNESCAPED_UNICODE); // 线上复诊的线下初诊记录信息
                            }
                            
                            if (isset($item['textRecords'])) {
                                $medical->textRecords = json_encode($item['textRecords'], JSON_UNESCAPED_UNICODE);
                            }

                            $medical->updated_at = Carbon::now();
                            // 保存数据
                            $medical->save();
                        }else{
                            $this->info('新建问诊：'. $item['visitNo']);
                            $medical = new MedicalModel();
                            $medical->visitNo = $item['visitNo'];
                            // 基本信息
                            $medical->idcardTypeCode = $item['idcardTypeCode'] ?? null; // 患者就诊卡证类型
                            $medical->idcardNo = $item['idcardNo'] ?? null; // 患者就诊卡证号码
                            $medical->name = $item['name'] ?? null; // 姓名
                            $medical->genderCode = $item['genderCode'] ?? null; // 性别代码
                            $medical->birthdate = $item['birthdate'] ?? null; // 出生日期

                            // 监护人信息（互联网患者年龄小于6岁时必填）
                            $medical->guardName = $item['guardName'] ?? null; // 监护人姓名
                            $medical->guardIdcardNo = $item['guardIdcardNo'] ?? null; // 监护人身份证号码

                            // 主诉和症状
                            $medical->subjComplaint = $item['subjComplaint'] ?? null; // 主诉记录
                            $medical->mainSymptoms = $item['mainSymptoms'] ?? null; // 主要监测症状代码组合

                            // 病史描述
                            $medical->prexHx = $item['prexHx'] ?? null; // 病史描述
                            $medical->prevHist = $item['prevHist'] ?? null; // 现病史
                            $medical->pastHist = $item['pastHist'] ?? null; // 既往史
                            $medical->alleHist = $item['alleHist'] ?? null; // 过敏史

                            // 中医诊断
                            $medical->tcmDdCode = $item['tcmDdCode'] ?? null; // 中医疾病诊断代码
                            $medical->tcmDdName = $item['tcmDdName'] ?? null; // 中医疾病诊断名称
                            $medical->tcmSdCode = $item['tcmSdCode'] ?? null; // 中医证候诊断代码
                            $medical->tcmSdName = $item['tcmSdName'] ?? null; // 中医证候诊断名称

                            // 西医诊断
                            $medical->mdDisCode = $item['mdDisCode'] ?? null; // 西医诊断疾病代码
                            $medical->mdDisName = $item['mdDisName'] ?? null; // 西医诊断疾病名称

                            // 其他诊断
                            $medical->disCode1 = $item['disCode1'] ?? null; // 其他诊断①疾病代码
                            $medical->disName1 = $item['disName1'] ?? null; // 其他诊断①疾病名称
                            $medical->disCode2 = $item['disCode2'] ?? null; // 其他诊断②疾病代码
                            $medical->disName2 = $item['disName2'] ?? null; // 其他诊断②疾病名称

                            // 医生描述
                            $medical->disDescription = $item['disDescription'] ?? null; // 医生对门诊诊断的描述
                            $medical->treatMeas = $item['treatMeas'] ?? null; // 处理措施

                            // 就诊医疗机构信息
                            $medical->unifiedOrgCode = $item['unifiedOrgCode'] ?? null; // 就诊医疗机构编码
                            $medical->orgName = $item['orgName'] ?? null; // 就诊医疗机构名称

                            // 就诊科室信息
                            $medical->deptCode = $item['deptCode'] ?? null; // 就诊科室编码
                            $medical->deptName = $item['deptName'] ?? null; // 就诊科室名称
                            $medical->deptClassCode = $item['deptClassCode'] ?? null; // 就诊科室对应诊疗科目编码
                            $medical->deptClassName = $item['deptClassName'] ?? null; // 就诊科室对应诊疗科目名称

                            // 就诊医师信息
                            $medical->doctIdcardNo = $item['doctIdcardNo'] ?? null; // 就诊医师身份证号
                            $medical->doctName = $item['doctName'] ?? null; // 就诊医师姓名

                            // 就诊时间
                            $medical->visitTimeStart = $item['visitTimeStart'] ?? null; // 就诊开始时间
                            $medical->visitTimeEnd = $item['visitTimeEnd'] ?? null; // 诊断结束时间

                            // 数字签名相关
                            $medical->doctCaSign = $item['doctCaSign'] ?? null; // 就诊医师电子签名
                            $medical->originalData = $item['originalData'] ?? null; // 数据原文
                            $medical->certificate = $item['certificate'] ?? null; // 数字证书

                            // 其他信息
                            $medical->reviewUrl = $item['reviewUrl'] ?? null; // 诊疗过程调阅地址
                            // 线下初诊记录（对象类型）
                            if (isset($item['firstVisitRecord'])) {
                                $medical->firstVisitRecord = json_encode($item['firstVisitRecord'], JSON_UNESCAPED_UNICODE); // 线上复诊的线下初诊记录信息
                            }

                            if (isset($item['textRecords'])) {
                                $medical->textRecords = json_encode($item['textRecords'], JSON_UNESCAPED_UNICODE);
                            }
                            // 保存数据
                            $medical->save();

                        }
                    }
                    print_r("maxPage:" . json_encode($response['data']['maxPage']) . "页\n");
                    // 更新分页信息
                    if (isset($response['data']['maxPage'])) {
                        $maxPage = $response['data']['maxPage'];
                    }
                    $pageNum++;
                    // if (isset($response['data']['pageNum'])) {
                    //     $pageNum = $response['data']['pageNum'] + 1; // 下一页
                    // } else {
                    //     $pageNum++; // 如果没有明确的 pageNum，手动递增
                    // }
                    print_r("pageNum:" . $pageNum . "页\n");
                } else {
                    Log::info('Medical-问诊信息- 接口异常' .json_encode($response));
                    echo "第 {$pageNum} 页查询失败。\n";
                    break; // 如果某页失败，停止翻页
                }

                if( $maxPage == 1 ){
                    break;
                }
            }
        }catch (\Exception $e) {
            Log::info('Medical-问诊信息- 代码异常' .json_encode($e));
            print_r($e->getMessage());
        }
        $this->info('问诊同步结束...');


    }
}
