<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DosageModel;
use App\Models\PharmacyModel;
use Illuminate\Http\Request;

// 用法用量控制器
class DosageController extends BaseApiController
{
    public function test()
    {
        return $this->success('ok');
    }

    // 获取用法用量
    public function dosageList(Request $request)
    {
        $authInfo = auth('api')->user();
        // 获取药店信息
        $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
        if (! $pharmacy) {
            return $this->failed('您的账号可能在其他设备登录，请重新登录！');
        }
        $dosages = DosageModel::where('pharmacy_id', $pharmacy->id)->get()->toArray();

        return $this->success($dosages);
    }
}
