<?php

namespace App\Admin\Metrics\Statistics;

use Dcat\Admin\Widgets\Metrics\Line;
use Illuminate\Http\Request;
use App\Models\PrescriptionModel;
use Dcat\Admin\Admin;
use Dcat\Admin\Widgets\Metrics\Bar;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
class PharmacyChart extends Bar
{
    /**
     * 初始化卡片内容
     *
     * @return void
     */
    protected function init()
    {
        parent::init();
        $date = date('Y-m-d',strtotime('-1 day'));
        $this->title($date .'开方药店数量');
    }

    /**
     * 处理请求
     *
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        // $query_time = date('Y-m-d 23:59:59');
        // $prescription_total = PrescriptionModel::where('created_at','<=',$query_time)->count();

        $yesterdayEnd = Carbon::yesterday()->endOfDay();
        $eightDaysAgoStart = clone $yesterdayEnd;
        $eightDaysAgoStart->subDays(7)->startOfDay();

        $datesRange = [];
        for ($date = clone $eightDaysAgoStart; $date->lte($yesterdayEnd); $date->addDay()) {
            $query_date = $date->format('Y-m-d');
            
            $res = DB::select(
                'SELECT COUNT(DISTINCT pharmacy_id) AS pharmacy_count 
                FROM prescription 
                WHERE created_at >= :start_of_day 
                AND created_at < :next_day 
                AND status = 2',
                [
                    'start_of_day' => $query_date . ' 00:00:00',
                    'next_day'     => $query_date . ' 23:59:59'
                ]
            );

            $datesRange[$query_date] = $res[0]->pharmacy_count;
        }

        // Log::info('结果123：'.json_encode($datesRange));
        $labels = array_keys($datesRange);
        $data = array_values($datesRange);
        // 卡片内容
        $this->withContent($data[7] ?? 0);
        // 图表数据
        $this->withChart([
            [
                'name' => '近七日开方药店量',
                'data' => $data,
            ],
        ]);

           
    }

    /**
     * 设置图表数据.
     *
     *
     * @return $this
     */
    public function withChart(array $data)
    {
        return $this->chart([
            'series' => $data,
        ]);
    }



    /**
     * 设置卡片内容.
     *
     * @param  string  $content
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
    
</div>
HTML
        );
    }
}
