<?php

namespace App\Admin\Controllers;

use App\Admin\Extensions\Form\PharmacyConfigForm;
use Dcat\Admin\Admin;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Layout\Content;

// 药店配置
class PharmacyConfigController extends AdminController
{
    public function index(Content $content): Content
    {
        // 权限判断和数据过滤
        if (! Admin::user()->isRole('pharmacy')) {
            admin_exit(Content::make()->withError(trans('admin.deny')));
        }

        return $content->header('药店配置')
            ->description('')
            ->body(new PharmacyConfigForm());
    }
}
