<?php

namespace App\Admin\Extensions\Form;

use Dcat\Admin\Widgets\Form;

// 全局设置
class SiteConfigForm extends Form
{
    public function handle(array $input)
    {
        $data = [
            'site_config' => $input,
        ];

        admin_setting($data);

        return $this
            ->response()
            ->location('site-config')
            ->success('设置成功');
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $data = admin_setting('site_config');
        $data = json_decode($data, true);

        $this->number('prescription_limit', '医师开方上限（每天）')->min(0)->required()->default(($data['prescription_limit'] ?? 0));

        $this->radio('prescription_period_status', '医师开方时间段')
            ->options([1 => '开启', 0 => '关闭'])->when(1, function (Form $form) use ($data) {
                $form->width(4)->time('prescription_period_start', '开始')->format('HH:mm')->rules('required_if:prescription_period_status,1')->setLabelClass(['asterisk'])->default(($data['prescription_period_start'] ?? ''));
                $form->width(4)->time('prescription_period_end', '截止')->format('HH:mm')->rules('required_if:prescription_period_status,1')->setLabelClass(['asterisk'])->default(($data['prescription_period_end'] ?? ''));
            })->default(($data['prescription_period_status'] ?? 0));

        $this->number('prescription_limit_buy_7', '1日内限购(全局)')->required()->default(($data['prescription_limit_buy_7'] ?? 1))->min(1)->max(10)->help('最多可设置10');
        $this->number('diagnosis_limit', '选择诊断数限制')->required()->default(($data['diagnosis_limit'] ?? 1))->min(1)->max(5)->help('诊断数选择设置1-5');
        $this->number('drug_choose_limit', '选择药品限制')->required()->default(($data['drug_choose_limit'] ?? 5))->min(1)->max(5)->help('药品目录选择数，最多可设置5');

        $this->number('doses_limit', '中药剂量限制')->required()->default(($data['doses_limit'] ?? 1))->min(1)->max(100)->help('剂量可选择最大值100');
        // $this->switch('prescription_auto', '医师自动开方')->default(($data['prescription_auto'] ?? 0));
        $this->text('limit_keywords', '麻黄素类药品限制关键词')->default($data['limit_keywords'] ?? '')->required()->help('多个关键词请用英文逗号分隔');
        $this->number('ephedrine_limit_buy_7', '麻黄素类药品7日内限购(全局)')->required()->default(($data['ephedrine_limit_buy_7'] ?? 1))->min(1)->max(10)->help('最多可设置10');

        $this->disableResetButton();
    }
}
