<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DiagnosiModel;
use App\Models\DoctorModel;
use App\Models\InquiryModel;
use App\Models\PatientModel;
use App\Models\PharmacistModel;
use App\Models\PharmacyDrugModel;
use App\Models\PharmacyModel;
use App\Models\PrescriptionLogModel;
use App\Models\PrescriptionModel;
use App\Models\User;
use App\Services\SmsService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Overtrue\EasySms\EasySms;

class StatisticsController extends BaseApiController
{

    public function index(Request $request)
    {
        $request = $request->all();
        // var_dump($request);
        if( !isset($request['token']) || $request['token'] !='imohe123@' ){
            echo '错误请求';exit();
        }
        // 搜索前一天的数据 23：59：59
        $query_time = date('Y-m-d 23:59:59', strtotime("-1 day"));
        $prev_start_time = date('Y-m-d 00:00:00', strtotime("-1 day"));
        $prev_end_time = date('Y-m-d 23:59:59', strtotime("-1 day"));
        $query_date = date('Y-m-d', strtotime("-1 day"));
        if( isset($request['date']) ){
            $query_time = date('Y-m-d 23:59:59', strtotime($request['date']));
            $prev_start_time = date('Y-m-d 00:00:00', strtotime($request['date']));
            $prev_end_time = date('Y-m-d 23:59:59', strtotime($request['date']));
            $query_date = date('Y-m-d', strtotime($request['date']));
        }
        $pharmacy_count = PharmacyModel::where('created_at','<=',$query_time)->count();
        $pharmacist_count = PharmacistModel::where('created_at','<=',$query_time)->count();
        $results = DB::select('SELECT count(pharmacy_id) FROM prescription WHERE created_at <= :query_time GROUP BY pharmacy_id having count(pharmacy_id) >=100', ['query_time' => $query_time]);
        $prescription_count = count($results);
        $prescription_total = PrescriptionModel::where('created_at','<=',$query_time)->count();
        $prescription_day_total = PrescriptionModel::where('created_at','<=',$prev_end_time)->where('created_at','>=',$prev_start_time)->count();
        
        $res = DB::select(
            'SELECT COUNT(DISTINCT pharmacy_id) AS pharmacy_count 
            FROM prescription 
            WHERE created_at >= :start_of_day 
            AND created_at < :next_day 
            AND status = 2', // 只统计审方成功的记录
            [
                'start_of_day' => $query_date . ' 00:00:00',
                'next_day' =>     $query_date . ' 23:59:59' 
            ]
        );
        // var_dump($res[0]->pharmacy_count);exit();
        $next_day_count = $res[0]->pharmacy_count;
        $patient_count = PatientModel::where('created_at','<=',$query_time)->count();
        echo  "统计数据(" .$query_time. "):<br />
                &nbsp;&nbsp;药店数量：". $pharmacy_count ."<br />
                &nbsp;&nbsp;药师数量：". $pharmacist_count ."<br />
                &nbsp;&nbsp;开方药店（处方数超过100单）：". $prescription_count ."<br />
                &nbsp;&nbsp;处方总量：". $prescription_total ."<br />
                &nbsp;&nbsp;问诊人数量：". $patient_count ."<br />
                &nbsp;&nbsp;" . $query_date . "开方量：". $prescription_day_total ."<br />
                &nbsp;&nbsp;" . $query_date . "开方药店量：". $next_day_count ."<br />
            ";exit();

    }


}