<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->rememberToken();

            $table->string('openid', 40)->nullable()->unique('uk_openid')->comment('小程序openid');
            $table->string('avatar')->nullable()->comment('头像');
            $table->string('nick_name', 100)->nullable()->comment('昵称');
            $table->tinyInteger('last_login_type')->default(0)->comment('最后一次登录类型[0=普通用户,1=医师,2=药师]');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
