<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pharmacy_drug', function (Blueprint $table) {
            $table->comment('药店药品');
            $table->bigIncrements('id');
            $table->bigInteger('pharmacy_id')->comment('药店ID');
            $table->bigInteger('drug_id')->comment('药品池ID');
            $table->string('unit', 20)->nullable()->comment('单位');
            $table->bigInteger('dosage_id')->nullable()->comment('用法用量表ID');
            $table->string('batch_no', 64)->nullable()->comment('批次号');
            $table->unique(['pharmacy_id', 'drug_id'], 'uk_pharmacyid_drugid');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pharmacy_drug');
    }
};
