<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Overtrue\Pinyin\Pinyin;

// 诊断
class DiagnosiModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    const DIAGNOSI_TYPE_WM = 0;

    const DIAGNOSI_TYPE_TCM = 1;

    // 诊断类型-文字映射
    const DIAGNOSI_TYPE_MAP = [
        self::DIAGNOSI_TYPE_WM => '西医',
        self::DIAGNOSI_TYPE_TCM => '中医',
    ];

    protected $table = 'diagnosis';

    public function setNameAttribute($value)
    {
        $this->attributes['name'] = $value;

        $pinyin = new Pinyin();
        $abbr = $pinyin->abbr($value)->join(''); // 获取拼音首字母
        $this->attributes['code'] = strtoupper($abbr);
    }
}
