<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('drug', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->index('idx_name')->comment('药品名称');
            $table->string('code')->index('idx_code')->comment('简码');
            $table->string('unit')->comment('单位');
            $table->string('spec')->comment('规格');
            $table->string('dosage_form')->comment('剂型');
            $table->string('factory')->index('idx_factory')->comment('生产厂家');
            $table->string('approval_no')->comment('批准文号');
            $table->integer('limit_buy_7')->default(0)->comment('7天内限购数量');
            $table->boolean('is_rx')->default(false)->comment('是否处方药');
            $table->text('tag')->nullable()->comment('标签');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('drug');
    }
};
