<?php

namespace App\Admin\Metrics\Statistics;

use App\Models\PharmacistModel;
use Dcat\Admin\Widgets\Metrics\Line;
use Illuminate\Http\Request;

class Pharmacist extends Line
{
    /**
     * 初始化卡片内容
     *
     * @return void
     */
    protected function init()
    {
        parent::init();

        $this->title('药师数量');

    }

    /**
     * 处理请求
     *
     *
     * @return mixed|void
     */
    public function handle(Request $request)
    {
        $query_time = date('Y-m-d 23:59:59');
        $pharmacist_count = PharmacistModel::where('created_at', '<=', $query_time)->count();
        // 卡片内容
        $this->withContent($pharmacist_count);

    }

    /**
     * 设置图表数据.
     *
     *
     * @return $this
     */
    public function withChart(array $data)
    {
        // return $this->chart([
        //     'series' => [
        //         [
        //             'name' => $this->title,
        //             'data' => $data,
        //         ],
        //     ],
        // ]);
    }

    /**
     * 设置卡片内容.
     *
     * @param  string  $content
     * @return $this
     */
    public function withContent($content)
    {
        return $this->content(
            <<<HTML
<div class="d-flex justify-content-between align-items-center mt-1" style="margin-bottom: 2px">
    <h2 class="ml-1 font-lg-1">{$content}</h2>
    
</div>
HTML
        );
    }
}
