<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('drug', function (Blueprint $table) {
            $table->string('preparation_pec')->default('')->comment('制剂规格');
            $table->string('product_name', 64)->default('')->comment('商品名');
            $table->string('mnemonic', 64)->default('')->comment('助记码');
            $table->string('category_code', 32)->default('')->comment('分类码');
            $table->string('category_name', 32)->default('')->comment('分类名称');
            $table->boolean('is_foreign')->default(false)->comment('是否进口药');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('drug', function (Blueprint $table) {
            //
        });
    }
};
