<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\DrugTagRepository;
use App\Models\InquiryModel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 药品标签
class DrugTagController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new DrugTagRepository('inquiry'), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id')->sortable();
            $grid->column('tag_name');
            $grid->column('inquiry')->display(function ($inquirys) {
                return collect($inquirys)->map(function ($inquiry) {
                    return "<span class='label' style='background:#6d8be6'>{$inquiry->question}</span>";
                })->implode('&nbsp;');
            });
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('tag_name')->width(3);
            });

            $grid->setActionClass(Grid\Displayers\Actions::class);
            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮
            $grid->disableViewButton(); // 禁用详情按钮
            $grid->disableRowSelector(); // 禁用行选择器

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new DrugTagRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('tag_name')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new DrugTagRepository('inquiry'), function (Form $form) {
            $form->display('id')->width(4);
            $form->text('tag_name')->width(4);
            $form->multipleSelect('inquiry', '问诊问题')
                ->options(function () {
                    return InquiryModel::all()->pluck('question', 'id');
                })
                ->customFormat(function ($v) {
                    return array_column($v, 'id');
                })->width(4);
            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
            $form->disableViewButton(); // 去掉跳转详情页按钮
        });
    }
}
