<?php

namespace App\Admin\Extensions\Form;

use App\Models\PharmacyModel;
use Dcat\Admin\Admin;
use Dcat\Admin\Widgets\Form;

// 药店设置
class PharmacyConfigForm extends Form
{
    public function handle(array $input)
    {
        $isAuto = $input['is_auto'] == 1 ? 1 : 0;
        $pharmacyId = Admin::user()->pharmacy_id;
        PharmacyModel::where('id', $pharmacyId)->update(['is_auto' => $isAuto]);

        return $this
            ->response()
            ->location('pharmacy-config')
            ->success('设置成功');
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $pharmacyId = Admin::user()->pharmacy_id;
        $isAuto = PharmacyModel::where('id', $pharmacyId)->value('is_auto');
        $this->switch('is_auto', '药店自动开方')->default($isAuto);

        $this->disableResetButton();
    }
}
