<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inquiry', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('question')->index('idx_question')->comment('问诊问题');
            $table->boolean('is_common')->default(1)->comment('通用[0=不是通用，1=通用]');
            $table->timestamps();
            $table->softDeletes();
        });
        \DB::statement("ALTER TABLE `inquiry` comment '问诊问题'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inquiry');
    }
};
