<?php

namespace App\Admin\Extensions\ToolBar\Forms;

use App\Models\DosageModel;
use App\Models\ExternalPrescriptionModel;
use App\Models\PharmacyModel;
use Dcat\Admin\Admin;
use Dcat\Admin\Http\JsonResponse;
use Dcat\Admin\Widgets\Form;
use Dcat\EasyExcel\Excel;
use Dcat\EasyExcel\Support\SheetCollection;
use Illuminate\Support\Facades\Log;
use Exception;

set_time_limit(1800);
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 10800);
ini_set('max_input_time', 10800);


class ExternalPrescriptionImportForm extends Form
{
    /**
     * 处理表单提交逻辑.
     */
    public function handle(array $input): JsonResponse
    {
       // 表单参数
       $file = $input['import_file'];
       $filePath = storage_path('app/'.$file);
       // Log::info("====>".$filePath);
       try {
           // 每100行数据为一批数据进行读取
           $chunkSize = 10;
           $successNum = 0;
           $failNum = 0;
           $data = Excel::import($filePath)->sheet('处方明细列表')->toArray();
           if(!empty($data) && is_array($data)){
                // 判断处方单编号是会否重复，如果重复需进行合并药品数据
                $prescriptions = [];
                foreach($data as $row){
                    $prescriptionNo = $row['处方编号'];
                    $drug_info['drug_name'] = $row['药品名称'] ?? '';
                    $drug_info['drug_spec'] = $row['药品规格'] ?? '';
                    $drug_info['drug_num'] = $row['药品数量'] ?? 0;
                    if(!isset($prescriptions[$prescriptionNo])){
                        $prescriptions[$prescriptionNo] = $row;
                    }
                    $prescriptions[$prescriptionNo]['药品明细'][] = $drug_info;
                }
                // 循环插入数据
                foreach($prescriptions as $prescriptionNo=>$prescription){
                    // 校验数据库中是否存在该数据
                    $externalPrescriptionModel = ExternalPrescriptionModel::where('external_prescription_id', $prescriptionNo)->first();
                    if( !$externalPrescriptionModel ){
                        $externalPrescriptionModel = new ExternalPrescriptionModel;
                    }
                    // 查找对应的药店ID
                    $pharmacy = PharmacyModel::where('name', $prescription['门店名称'])->first();
                    $pharmacyId = 0;
                    if( $pharmacy ){
                        $pharmacyId = $pharmacy->id;
                    }
                    $externalPrescriptionModel->external_prescription_id = $prescriptionNo;
                    $externalPrescriptionModel->issue_at = $prescription['处方开具时间'];
                    $externalPrescriptionModel->status = $prescription['处方状态'];
                    $externalPrescriptionModel->company_name = $prescription['企业名称'];
                    $externalPrescriptionModel->pharmacy_name = $prescription['门店名称'];
                    $externalPrescriptionModel->pharmacy_id = $pharmacyId;
                    $externalPrescriptionModel->agent = $prescription['会员/代理人'];
                    $externalPrescriptionModel->patient_name = $prescription['就诊人姓名'];
                    $externalPrescriptionModel->patient_mobile = $prescription['就诊人电话'];
                    $externalPrescriptionModel->patient_gender = self::getGender($prescription['就诊人性别']);
                    $externalPrescriptionModel->patient_age = $prescription['就诊人年龄'];
                    $externalPrescriptionModel->patient_id_card = $prescription['就诊人身份证号'] ?? '';
                    $externalPrescriptionModel->doctor_name = $prescription['接诊医师姓名'] ?? '';
                    $externalPrescriptionModel->diagnosis = $prescription['诊断'];
                    $externalPrescriptionModel->drug_info = json_encode($prescription['药品明细']);
                    $externalPrescriptionModel->pharmacist_name = $prescription['审核药师'] ?? '';
                    $externalPrescriptionModel->review_at = $prescription['药师审核时间'] ?? '';
                    $externalPrescriptionModel->pharmacist_attr = $prescription['药师属性'] ?? '';
                    $externalPrescriptionModel->dispatcher = $prescription['调配人'] ?? '';
                    $externalPrescriptionModel->checker = $prescription['核对人'] ?? '';
                    $externalPrescriptionModel->dispenser = $prescription['发药人'] ?? '';
                    if( $externalPrescriptionModel->save() ){
                        $successNum++;
                    }
                }
                // Log::info("prescriptions====>".json_encode($prescriptions));
           }
           
           $return = $this->response()->success("导入成功{$successNum}条")->refresh();
           unlink($filePath);
       } catch (Exception $e) {
           $return = $this->response()->error("导入失败{$failNum}条：".$e->getMessage());
       }

       return $return;
    }

    /**
     * 构造表单.
     */
    public function form()
    {
        $this->file('import_file', '文件')
            ->disk('local')
            ->accept('xlsx,csv')
            ->maxSize(1024 * 30)
            ->autoUpload()
            ->uniqueName()
            ->required()
            ->help("导入要求：<br />
                   <span style='color:red;'>
                   1、支持xlsx、csv两种格式
                   </span>");
        // $downloadUrl = admin_url('dosage-template');
        // $this->html("<a target='_blank' href='{$downloadUrl}'>下载用法用量导入模板</a>");
    }


    private static function getGender($value){
        $value = trim($value);
        switch ($value) {
            case '男':
                return 1;
            case '女':
                return 2;
            default:
                return 0;
        }
    }

}