<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('prescription_log', function (Blueprint $table) {
            $table->comment('处方日志');
            $table->bigIncrements('id');
            $table->bigInteger('pharmacy_id')->comment('药店ID');
            $table->string('pharmacy_name')->comment('药店名称');
            $table->text('log_info')->comment('日志描述');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prescription_log');
    }
};
