<?php

namespace App\Admin\Extensions\ToolBar\Forms;

use App\Models\DrugModel;
use Dcat\Admin\Http\JsonResponse;
use Dcat\Admin\Widgets\Form;
use Dcat\EasyExcel\Excel;
use Dcat\EasyExcel\Support\SheetCollection;
use Exception;

class DrugImportForm extends Form
{
    const IS_MAP = [
        'Y' => 1,
        'N' => 0,
    ];

    /**
     * 处理表单提交逻辑.
     */
    public function handle(array $input): JsonResponse
    {
        // 表单参数
        $file = $input['import_file'];
        $filePath = storage_path('app/'.$file);
        try {
            // 每100行数据为一批数据进行读取
            $chunkSize = 10;
            $successNum = 0;
            $failNum = 0;
            Excel::import($filePath)->first()->chunk($chunkSize, function (SheetCollection $collection) use ($successNum) {
                // 此处的数组下标依然是excel表中数据行的行号
                $rows = $collection->toArray();
                foreach ($rows as $row) {
                    $drugModel = new DrugModel;
                    $drugModel->name = $row['药品名称'];
                    $drugModel->code = '';
                    $drugModel->standard_code = $row['本位码'];
                    $drugModel->unit = $row['单位'];
                    $drugModel->spec = $row['规格'];
                    $drugModel->dosage_form = $row['剂型'];
                    $drugModel->factory = $row['生产厂家'];
                    $drugModel->approval_no = $row['批准文号'];
                    $drugModel->is_rx = self::IS_MAP[$row['是否处方药']];
                    $drugModel->is_si = self::IS_MAP[$row['是否医保药品']];
                    $drugModel->product_id = $row['君元ID'] ?? 0;
                    if ($drugModel->save()) {
                        $successNum++;
                    }
                }
            });
            $return = $this->response()->success("导入成功{$successNum}条")->refresh();
            unlink($filePath);
        } catch (Exception $e) {
            $return = $this->response()->error("导入失败{$failNum}条：".$e->getMessage());
        }

        return $return;
    }

    /**
     * 构造表单.
     */
    public function form()
    {
        $this->file('import_file', '文件')
            ->disk('local')
            ->accept('xls,xlsx,csv')
            ->autoUpload()
            ->uniqueName()
            ->required()
            ->help("导入要求：<br />
                   <span style='color:red;'>
                   1、支持xls、xlsx、csv三种格式
                   </span>");
        $downloadUrl = admin_url('drug-template');
        $this->html("<a target='_blank' href='{$downloadUrl}'>下载药品导入模板</a>");
    }
}
