<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\DoctorRepository;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 医师
class DoctorController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new DoctorRepository(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('name');
            $grid->column('mobile');
            $grid->column('id_card');
            $grid->column('license_no');
            $grid->column('license_no_pic')->image('', 50, 50);
            $grid->column('license_no_period');
            $grid->column('physician_license')->image('', 50, 50);
            $grid->column('id_card_front_pic')->image('', 50, 50);
            $grid->column('id_card_back_pic')->image('', 50, 50);
            $grid->column('online_hospital_name');
            $grid->column('department');
            $grid->column('doctor_title');
            $grid->column('be_good_at');
            $grid->column('introduction');
            $grid->column('signed_pic')->image('', 50, 50);
            $grid->column('status');

            // 快捷搜索
            $grid->quickSearch(['name', 'mobile', 'id_card'])->placeholder('请输入[姓名|手机号|身份证号码]')->width(25);

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('name')->width(3);
                $filter->like('id_card')->width(3);
                $filter->like('mobile')->width(3);
            });

            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new DoctorRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('name')->width(4);
            $show->field('id_card')->width(4);
            $show->field('license_no')->width(4);
            $show->field('license_no_pic')->width(4)->image('', 50, 50);
            $show->field('license_no_period')->width(4);
            $show->field('physician_license')->width(4)->image('', 50, 50);
            $show->field('id_card_front_pic')->width(4)->image('', 50, 50);
            $show->field('id_card_back_pic')->width(4)->image('', 50, 50);
            $show->field('online_hospital_name')->width(4);
            $show->field('department')->width(4);
            $show->field('doctor_title')->width(4);
            $show->field('be_good_at')->width(4);
            $show->field('introduction')->width(4);
            $show->field('status')->width(4);
            $show->field('status')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new DoctorRepository(), function (Form $form) {
            $form->display('id')->width(4);
            $form->text('name')->width(4);
            $form->text('id_card')->width(4);
            $form->text('license_no')->width(4);
            $form->image('license_no_pic')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->text('license_no_period')->width(4);
            $form->image('physician_license')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('id_card_front_pic')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->image('id_card_back_pic')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->text('online_hospital_name')->width(4);
            $form->text('department')->width(4);
            $form->text('doctor_title')->width(4);
            $form->textarea('be_good_at')->width(4);
            $form->textarea('introduction')->width(4);
            $form->image('signed_pic')->accept('jpg,png,jpeg')->uniqueName()->autoUpload()->retainable()->removable(false)->width(4);
            $form->switch('status')->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
