<?php

namespace App\Admin\Extensions\Form;

use Dcat\Admin\Widgets\Form;

// 全局设置
class PharmacyConfigForm extends Form
{
    public function handle(array $input)
    {
        $data = [
            'site_config' => $input,
        ];

        admin_setting($data);

        return $this
            ->response()
            ->location('site-config')
            ->success('设置成功');
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $data = admin_setting('site_config');
        $data = json_decode($data, true);

        $this->switch('prescription_auto', '医师自动开方');

        $this->disableResetButton();
    }
}
