<?php

namespace App\Models\Common;

use Dcat\Admin\Models\Administrator;
use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @property string $item
 * @property int $operator
 * @property int $id
 */
class ImportLogModel extends Model
{
    use HasDateTimeFormatter;

    protected $table = 'import_log';

    // 导入文件处理状态：状态取值[0=待处理,1=处理中,2=处理成功,3=处理失败]
    const PROCESS_STATUS_WAIT = 0;

    const PROCESS_STATUS_DOING = 1;

    const PROCESS_STATUS_SUCCESS = 2;

    const PROCESS_STATUS_FAILED = 3;

    // 导入文件处理状态-文字映射
    const PROCESS_STATUS_MAP = [
        self::PROCESS_STATUS_WAIT => '待处理',
        self::PROCESS_STATUS_DOING => '处理中',
        self::PROCESS_STATUS_SUCCESS => '处理成功',
        self::PROCESS_STATUS_FAILED => '处理失败',
    ];

    // 导入文件处理状态-颜色映射
    const PROCESS_STATUS_COLOR = [
        self::PROCESS_STATUS_WAIT => 'default',
        self::PROCESS_STATUS_DOING => 'warning',
        self::PROCESS_STATUS_SUCCESS => 'success',
        self::PROCESS_STATUS_FAILED => 'danger',
    ];

    // 导入模块：状态取值[sku=SKU,coupon=优惠券]
    const IMPORT_ITEM_SKU = 'sku';

    const IMPORT_ITEM_COUPON = 'coupon';

    // 导入文件处理状态-文字映射
    const IMPORT_ITEM_MAP = [
        self::IMPORT_ITEM_SKU => 'SKU',
        self::IMPORT_ITEM_COUPON => '优惠券',
    ];

    /**
     * 导入日志有一个操作者.
     */
    public function operator(): BelongsTo
    {
        return $this->belongsTo(Administrator::class, 'operator', 'id');
    }
}
