<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DrugModel;
use App\Models\User;
use App\Models\PharmacyDrugModel;
use App\Models\PharmacyModel;
use Illuminate\Http\Request;

// 药品控制器
class DrugController extends BaseApiController
{
    public function test()
    {
        $search_input = '测试';
        $data = PharmacyDrugModel::where('pharmacy_id', 1)
            ->whereHas('drug', function ($query) use ($search_input) {
                $query->where('name', 'LIKE', "%{$search_input}%")
                    ->orWhere('code', 'LIKE', "%{$search_input}%"); // 这里的'%筛选条件%'是你想要匹配的药品名称
            })
            ->paginate(10);

        // $drugs = $data->map(function ($row) {
        //     return $row->drug;
        // });
        return $this->success($data);
    }

    // 药品列表
    public function drugList(Request $request)
    {
        $authInfo = auth('api')->user();
        $pharmacy_id = 0;
        if ($authInfo->last_login_type== User::LOGIN_TYPE_USER) {
            $pharmacy_id = $request->input('pharmacy_id');
        }else if ($authInfo->last_login_type== User::LOGIN_TYPE_PHARMACY) {
            $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
            $pharmacy_id = $pharmacy->id;
        }
        $search_input = $request->input('search_input');
        $data = PharmacyDrugModel::where('pharmacy_id', $pharmacy_id)
            ->whereHas('drug', function ($query) use ($search_input) {
                if ($search_input) {
                    $query->where('name', 'LIKE', "%{$search_input}%")
                        ->orWhere('code', 'LIKE', "%{$search_input}%"); // 这里的'%筛选条件%'是你想要匹配的药品名称
                }
            })
            ->paginate(10);

        return $this->success($data);
    }

    // 药品7日内限购
    public function drugLimit(Request $request)
    {
        $drug_id = $request->input('drug_id');
        // 判断当前药品有没有设置7日内限购
        $drug = DrugModel::query()->find($drug_id);
        // 当前药品未设置则使用全局的7日内限购
        $limit_num = 0;
        if ($drug->limit_num == 0) {

        }

        return $this->success($limit_num);

    }
}
