<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dosage', function (Blueprint $table) {
            $table->comment('用法用量');
            $table->bigIncrements('id');
            $table->bigInteger('pharmacy_id')->comment('药店表ID');
            $table->string('dosage_desc', 128)->comment('用法用量');
            $table->string('dosage_show')->comment('显示内容');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dosage');
    }
};
