<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

// 不需要登录的组
// 小程序静默登录
Route::post('login', 'App\Api\Controllers\UserController@login');

// 需要验证是否登录的路由组
Route::middleware(['jwt.auth'])->group(function () {
    // 获取用户信息
    Route::get('/users', 'App\Api\Controllers\UserController@userInfo');
});