<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

// 不需要登录的组
// 小程序静默登录
Route::post('login', 'App\Api\Controllers\UserController@login');
Route::get('test', 'App\Api\Controllers\DrugController@test');




// 需要验证是否登录的路由组
Route::middleware(['jwt.auth', 'checkrole'])->group(function () {
    // 获取用户信息
    Route::get('/users', 'App\Api\Controllers\UserController@userInfo');
    // 退出
    Route::post('logout', 'App\Api\Controllers\UserController@logout');
    // 刷新token
    Route::post('refresh', 'App\Api\Controllers\UserController@refresh');
    # 获取发送验证码
    Route::post('/smscode', 'App\Api\Controllers\UserController@smsCode');
    # 角色绑定
    Route::post('/role-bind', 'App\Api\Controllers\UserController@bindRole');

    # 获取药品列表
    Route::get('/drugs', 'App\Api\Controllers\DrugController@drugList');
    # 药品限购
    Route::post('/drug-limit', 'App\Api\Controllers\DrugController@drugLimit');
    # Route::get('/test', 'App\Api\Controllers\DrugController@test');
    # 获取药店列表
    Route::get('/pharmacys', 'App\Api\Controllers\PharmacyController@PharmacyList');
    # 药店详情
    Route::post('/pharmacy-detail', 'App\Api\Controllers\PharmacyController@detail');
    # 药店纠错
    Route::post('/pharmacy-correction', 'App\Api\Controllers\PharmacyController@correction');
    # 药店审方
    Route::post('/pharmacy-prescription', 'App\Api\Controllers\PharmacyController@prescription');
    # 药店营业时间
    Route::post('/pharmacy-time', 'App\Api\Controllers\PharmacyController@setBusinessTime');
    # 开店或闭店
    Route::post('/pharmacy-open', 'App\Api\Controllers\PharmacyController@open');
    # 药店退出
    Route::post('/pharmacy-logout', 'App\Api\Controllers\PharmacyController@logout');
    # 获取诊断列表
    Route::get('/diagnosis', 'App\Api\Controllers\DiagnosisController@diagnosisList');
    # 获取问诊人列表
    Route::get('/patients', 'App\Api\Controllers\PatientController@patientList');
    # 问诊人新增
    Route::post('/patients-add', 'App\Api\Controllers\PatientController@add');
    # 问诊人编辑
    Route::post('/patients-update', 'App\Api\Controllers\PatientController@update');
    # 问诊人删除
    Route::post('/patients-delete', 'App\Api\Controllers\PatientController@delete');
    # 设置默认问诊人
    Route::post('/patients-setdefault', 'App\Api\Controllers\PatientController@setDefault');
    # 获取默认问诊人
    Route::post('/patients-getdefault', 'App\Api\Controllers\PatientController@getDefault');
    # 获取问诊问题列表
    Route::get('/inquirys', 'App\Api\Controllers\InquiryController@InquirytList');
    # 处方列表
    Route::get('/prescriptions', 'App\Api\Controllers\PrescriptionController@prescriptionList');
    # 处方详情
    Route::post('/prescription-detail', 'App\Api\Controllers\PrescriptionController@detail');
    # 处方作废
    Route::post('/prescription-invalid', 'App\Api\Controllers\PrescriptionController@invalid');
    # 开方
    Route::post('/prescription-create', 'App\Api\Controllers\PrescriptionController@create');
    # 医师详情
    Route::post('/doctor-detail', 'App\Api\Controllers\DoctorController@detail');
    # 医师上传签名
    Route::post('/doctor-upload', 'App\Api\Controllers\DoctorController@upload');
    # 医师纠错
    Route::post('/doctor-correction', 'App\Api\Controllers\DoctorController@correction');
    # 医师退出
    Route::post('/doctor-logout', 'App\Api\Controllers\DoctorController@logout');
    # 医师自动开方
    Route::post('/doctor-auto', 'App\Api\Controllers\DoctorController@isAuto');
    # 医师开方
    Route::post('/doctor-prescription', 'App\Api\Controllers\DoctorController@prescription');
    # 药师列表
    Route::get('/pharmacists', 'App\Api\Controllers\PharmacistController@pharmacistList');
    # 药师详情
    Route::post('/pharmacist-detail', 'App\Api\Controllers\PharmacistController@detail');
    # 证书上传
    Route::post('/pharmacist-uploadcertificate', 'App\Api\Controllers\PharmacistController@uploadCertificate');
    # 药师新增
    Route::post('/pharmacist-add', 'App\Api\Controllers\PharmacistController@add');
    # 药师编辑
    Route::post('/pharmacist-update', 'App\Api\Controllers\PharmacistController@update');
    # 设置默认药师
    Route::post('/pharmacist-setdefault', 'App\Api\Controllers\PharmacistController@setDefault');
    # 药师签名上传
    Route::post('/pharmacist-upload', 'App\Api\Controllers\PharmacistController@upload');
    # 药师删除
    Route::post('/pharmacist-delete', 'App\Api\Controllers\PharmacistController@delete');
});