<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PatientModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'patient';

    // 性别[0=未知,1=男,2=女]
    const SEX_UNDEFINED = 0;

    const SEX_MALE = 1;

    const SEX_FEMALE = 2;

    // 性别-文字映射
    const SEX_MAP = [
        self::SEX_UNDEFINED => '未知',
        self::SEX_MALE => '男',
        self::SEX_FEMALE => '女',
    ];

    // 是否默认[0=否,1=是]
    const IS_DEFAULT_FALSE = 0;

    const IS_DEFAULT_TRUE = 1;

    // 是否默认-文字映射
    const IS_DEFAULT_MAP = [
        self::IS_DEFAULT_FALSE => '否',
        self::IS_DEFAULT_TRUE => '是',
    ];

    // 是否默认-颜色映射
    const IS_DEFAULT_MAP_COLOR = [
        self::IS_DEFAULT_FALSE => 'gray',
        self::IS_DEFAULT_TRUE => 'success',
    ];

    /**
     * 根据身份证设置性别
     */
    public function setIdCardAttribute($value)
    {
        $this->attributes['id_card'] = $value;
        $this->attributes['gender'] = getSexByIdCard($this->id_card) ?? self::SEX_UNDEFINED;
    }

    // 问诊人所属于的用户,多对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // 问诊人所属于的药店,多对一
    public function pharmacy()
    {
        return $this->belongsTo(PharmacyModel::class, 'pharmacy_id', 'id');
    }
}
