## 版本要求
- centos
- php8.1及以上
- mysql5.7及以上

## 初始化安装

```
1、安装composer

2、安装php依赖包
composer install

3、复制 .env.example 为 .env

4、执行生成app_key
php artisan key:generate

5、配置数据库，修改.env文件
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=dcat-admin
DB_USERNAME=root
DB_PASSWORD=

6、配置好后执行命令更新数据库表
php artisan migrate

7、覆盖菜单表、角色表数据
php artisan db:seed --class=AdminTablesSeeder
第一次安装执行 php artisan db:seed --class=InitSeeder
初始化的账号:admin,密码:admin

8、创建后台超级管理员账号
php artisan admin:create-user

9、启动服务
php artisan serve

10、访问
http://127.0.0.1:8000
用刚刚创建的账号密码进行登录

11、启用扩展
进入系统，点击“系统>>扩展”，点击列表中的“更新”，再点击“启用”
```

## 单独更新数据库
```
php artisan migrate
```

## 覆盖菜单表、角色表数据
```
php artisan db:seed --class=AdminTablesSeeder

```

## 后台账号创建
```
php artisan admin:create-user
```

## 启动服务
```
php artisan serve
然后浏览器直接访问即可
```

## 备份菜单，权限，账号等数据
```
php artisan admin:export-seed

```

## 备份数据库表，如地区表,多个表，用逗号隔开
```
php artisan iseed 表名 --force
常用
php artisan iseed street

```

## dcat-admin开发文档

https://learnku.com/docs/dcat-admin/2.x

## laravel 9.x开发文档

https://learnku.com/docs/laravel/9.x

## 路由缓存
php artisan api:cache

如果更新了路由需要连续执行下面命令
php artisan route:clear
php artisan api:cache

## 缓存配置
php artisan config:cache

如果更新了配置需要连续执行下面命令
php artisan config:clear
php artisan config:cache

## 优化 Composer 自动加载
composer dump-autoload  -o

## 更新model文件的字段注释
php artisan ide-helper:models "App\Models\Shop\model名称"

## 格式化代码
composer fix-style