<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\DrugModel;
use App\Models\PharmacyDrugModel;
class InitPharmacyDrugTcm extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mohe:init-pharmacy-drug-tcm {pharmacy_id}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '同步中药到指定药店';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        //
        $pharmacy_id = $this->argument('pharmacy_id') ?? 0;
        if (intval($pharmacy_id) < 1) {
            $this->info('请输入正确的药店id');
            return;
        }
        $this->info('开始同步药库中药到指定药店...');
        $drugs = DrugModel::query()->where('drug_type',DrugModel::DRUG_TYPE_TCM)->get();
        if( $drugs->count() > 0 ){
            foreach ($drugs as $drug) {
                $pharmacyDrug = PharmacyDrugModel::where('pharmacy_id',$pharmacy_id)->where('drug_id',$drug->id)->first();
                if( empty($pharmacyDrug) ){
                    $pharmacyDrug = new PharmacyDrugModel();
                    $pharmacyDrug->drug_id = $drug->id;
                    $pharmacyDrug->pharmacy_id = $pharmacy_id;
                    $pharmacyDrug->unit = $drug->unit;
                    $pharmacyDrug->save();
                }
            }
        }
    }
}
