<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class PrescriptionModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'prescription';

    // 数组json相互转换
    protected $casts = [
        'drug_info' => 'array',
        'inquiry_info' => 'array',
    ];

    // 审方状态[0=待开方,1=待审方,2=审方成功]
    const PRESCRIPTION_STATUS_PENDING = 0;

    const PRESCRIPTION_STATUS_REVIEWING = 1;

    const PRESCRIPTION_STATUS_SUCCESS = 2;

    // 审方状态-文字映射
    const PRESCRIPTION_STATUS_MAP = [
        self::PRESCRIPTION_STATUS_PENDING => '待开方',
        self::PRESCRIPTION_STATUS_REVIEWING => '待审方',
        self::PRESCRIPTION_STATUS_SUCCESS => '审方成功',
    ];

    // 审方状态-文字映射
    const PRESCRIPTION_STATUS_MAP_COLOR = [
        self::PRESCRIPTION_STATUS_PENDING => 'info',
        self::PRESCRIPTION_STATUS_REVIEWING => 'warning',
        self::PRESCRIPTION_STATUS_SUCCESS => 'success',
    ];

    // 开方来源[0=客开,1=店开]
    const OPEN_SOURCE_CUSTOMER = 0;

    const OPEN_SOURCE_PHARMACY = 1;

    // 开方来源-文字映射
    const OPEN_SOURCE_MAP = [
        self::OPEN_SOURCE_CUSTOMER => '客开',
        self::OPEN_SOURCE_PHARMACY => '店开',
    ];

    // 异常处方单状态[0=否,1=是]
    const IS_ABNORMAL_FALSE = 0;

    const IS_ABNORMAL_TRUE = 1;

    // 异常处方单状态-文字映射
    const IS_ABNORMAL_MAP = [
        self::IS_VOIDED_FALSE => '否',
        self::IS_VOIDED_TRUE => '是',
    ];

    // 异常处方单状态-颜色映射
    const IS_ABNORMAL_MAP_COLOR = [
        self::IS_VOIDED_FALSE => 'gray',
        self::IS_VOIDED_TRUE => 'danger',
    ];

    // 作废状态[0=未作废,1=作废]
    const IS_VOIDED_FALSE = 0;

    const IS_VOIDED_TRUE = 1;

    // 作废状态-文字映射
    const IS_VOIDED_MAP = [
        self::IS_VOIDED_FALSE => '未作废',
        self::IS_VOIDED_TRUE => '作废',
    ];

    // 作废状态-颜色映射
    const IS_VOIDED_MAP_COLOR = [
        self::IS_VOIDED_FALSE => 'gray',
        self::IS_VOIDED_TRUE => 'danger',
    ];

    // 处方类型[0=西药,1=中药]
    const PRESCRIPTION_TYPE_WM = 0;

    const PRESCRIPTION_TYPE_TCM = 1;

    // 处方类型-文字映射
    const PRESCRIPTION_TYPE_MAP = [
        self::PRESCRIPTION_TYPE_WM => '西药',
        self::PRESCRIPTION_TYPE_TCM => '中药',
    ];

    public function getDoctorSignedPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPharmacistSignedPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPrescriptionPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPrescriptionPicEsealAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }
}
