<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\InquiryRepository;
use App\Models\InquiryModel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 问诊问题
class InquiryController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new InquiryRepository(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id')->sortable();
            $grid->column('question');
            $grid->column('is_common')->using(InquiryModel::INQUIRY_COMMON_MAP);

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('question')->width(3);
            });

            $grid->setActionClass(Grid\Displayers\Actions::class);
            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮
            $grid->disableViewButton(); // 禁用详情按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new InquiryRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('question')->width(4);
            $show->field('is_common')->width(4)->using(InquiryModel::INQUIRY_COMMON_MAP);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableEdit(); // 禁止编辑
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new InquiryRepository(), function (Form $form) {
            $form->display('id')->width(4);
            $form->text('question')->width(4)->required();
            $form->switch('is_common')->default(1)->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
            $form->disableViewButton(); // 去掉跳转详情页按钮
        });
    }
}
