<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;

class BaseApiController extends Controller
{
    /**
     * 返回成功信息
     *
     * @param  mixed  $data
     */
    public function success($data = [], string $message = 'success', int $code = Response::HTTP_OK): \Illuminate\Http\JsonResponse
    {
        return response()->json(['status' => true, 'code' => $code, 'message' => $message, 'data' => $data]);
    }

    /**
     * 返回失败信息
     *
     * @param  bool  $status
     */
    public function failed($data = [], string $message = 'fail', int $code = Response::HTTP_INTERNAL_SERVER_ERROR): \Illuminate\Http\JsonResponse
    {
        return response()->json(['status' => false, 'code' => $code, 'message' => $message, 'data' => $data]);
    }
}
