<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prescription', function (Blueprint $table) {
            $table->comment('处方单');
            $table->bigIncrements('id')->startingValue(10000001)->comment('处方单编号');
            // $table->string('prescription_umber', 64)->nullable()->comment('处方单编号');
            $table->tinyInteger('status')->comment('审方状态[0=待开方,1=待审方,2=审方成功]');

            $table->bigInteger('user_id')->default(0)->comment('用户表ID。药店添加则为0');

            $table->bigInteger('patient_id')->default(0)->comment('问诊人表ID');
            $table->string('patient_name', 50)->comment('问诊人姓名');
            $table->integer('patient_age')->default(0)->comment('问诊人年龄');
            $table->tinyInteger('patient_gender')->default(0)->comment('问诊人性别。[1=男性,2=女性,0=未知]');
            $table->bigInteger('diagnosis_id')->default(0)->comment('诊断表ID');
            $table->string('diagnosis_name')->nullable()->comment('诊断');

            $table->text('inquiry_info')->comment('问诊问题');

            $table->text('drug_info')->nullable()->comment('用药信息');

            $table->bigInteger('doctor_id')->default(0)->comment('医师表ID');
            $table->string('doctor_name', 50)->nullable()->comment('医师姓名');
            $table->string('doctor_online_hospital_name', 128)->nullable()->comment('医师互联网医院名称');
            $table->string('doctor_department', 128)->nullable()->comment('医师科室');
            $table->string('doctor_title', 64)->nullable()->comment('医师职称');
            $table->string('doctor_license_no', 30)->nullable()->comment('医师执照编号');
            $table->longText('doctor_signed_pic')->nullable()->comment('医师签名照');

            $table->bigInteger('pharmacy_id')->default(0)->comment('药店表ID');
            $table->string('pharmacy_name', 64)->nullable()->comment('药店名称');

            $table->bigInteger('pharmacist_id')->default(0)->comment('药师表ID');
            $table->string('pharmacist_name', 50)->nullable()->comment('药师姓名');
            $table->string('pharmacist_license_number', 32)->nullable()->comment('药师执照编号');
            $table->longText('pharmacist_signed_pic')->nullable()->comment('药师签名照');

            $table->string('prescription_pic')->nullable()->comment('处方单图片地址');
            $table->boolean('is_voided')->default(0)->comment('作废状态[0=未作废，1=作废]');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prescription');
    }
};
