<?php

namespace App\Admin\Extensions\ToolBar\Actions;

use App\Admin\Extensions\ToolBar\Forms\DrugImportForm;
use Dcat\Admin\Grid\Tools\AbstractTool;
use Dcat\Admin\Widgets\Modal;

class DrugImportAction extends AbstractTool
{
    public $title = '导入药品';

    public function html(): Modal
    {
        return Modal::make()
            ->lg()
            ->title($this->title)
            ->body(new DrugImportForm())
            ->button("<button class='btn btn-success'><i class='feather icon-upload'></i>&nbsp;{$this->title}</button>");
    }
}
