<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExternalPrescriptionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('external_prescription', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('external_prescription_id')->default('')->comment('外部处方单编号');
            $table->timestamp('issue_at')->comment('处方开具时间');
            $table->string('status')->default('')->comment('状态');
            $table->string('company_name')->default('')->comment('企业名称');
            $table->string('pharmacy_name')->default('')->comment('药店名称');
            $table->integer('pharmacy_id')->comment('药店编号');
            $table->string('agent')->default('')->comment('会员/代理人');
            $table->string('patient_name')->default('')->comment('就诊人姓名');
            $table->string('patient_mobile')->default('')->comment('就诊人手机号');
            $table->tinyInteger('patient_gender')->comment('性别。[1=男性,2=女性,0=未知]');
            $table->integer('patient_age')->comment('就诊人年龄');
            $table->string('patient_id_card')->nullable()->comment('就诊人身份证');
            $table->string('doctor_name')->default('')->comment('接诊医师');
            $table->string('diagnosis')->default('')->comment('诊断');
            $table->text('drug_info')->nullable()->comment('用药信息');
            $table->string('pharmacist_name')->nullable()->comment('审核药师');
            $table->timestamp('review_at')->nullable()->comment('审核时间');
            $table->string('pharmacist_attr')->nullable()->comment('药师属性');
            $table->string('dispatcher')->nullable()->comment('调配人');
            $table->string('checker')->nullable()->comment('核对人');
            $table->string('dispenser')->nullable()->comment('发药人');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('external_prescription');
    }
}
