<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PrescriptionModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'prescription';

    // 审方状态[0=待开方,1=待审方,2=审方成功]
    const PRESCRIPTION_STATUS_PENDING = 0;

    const PRESCRIPTION_STATUS_REVIEWING = 1;

    const PRESCRIPTION_STATUS_SUCCESS = 2;

    // 审方状态-文字映射
    const PRESCRIPTION_STATUS_MAP = [
        self::PRESCRIPTION_STATUS_PENDING => '待开方',
        self::PRESCRIPTION_STATUS_REVIEWING => '待审方',
        self::PRESCRIPTION_STATUS_SUCCESS => '审方成功',
    ];
}
