<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DiagnosiModel;
use Illuminate\Http\Request;

// 诊断控制器
class DiagnosisController extends BaseApiController
{
    public function test()
    {
        return $this->success(['a' => 1, 'b' => 2, 'c' => 3]);
    }

    // 获取诊断列表
    public function diagnosisList(Request $request)
    {
        $search_input = $request->input('search_input');
        $type = $request->input('type', 0);
        $query = DiagnosiModel::query()->where('type', $type);
        if ($search_input) {
            $query->where('name', 'like', "%{$search_input}%")
                ->orWhere('code', 'like', "%{$search_input}%");
        }
        $data = $query->paginate(20);

        return $this->success($data);
    }
}
