<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DrugTagModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'drug_tag';

    // 药品标签关联问诊问题，多对多
    public function inquiry()
    {
        $relatedModel = InquiryModel::class; // 药品标签要关联的问诊问题模型类名

        $pivotTable = 'drug_tag_related_inquiry'; // 药品标签和问诊问题关联中间表

        return $this->belongsToMany($relatedModel, $pivotTable, 'tag_id', 'inquiry_id')->withTimestamps();
    }
}
