<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

// 药店
class PharmacyModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacy';

    // 药店所属于的用户,一对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // 药店关联的药师,一对多
    public function pharmacist()
    {
        return $this->hasMany(PharmacistModel::class, 'pharmacist_id', 'id');
    }

    // 药店关联的问诊人,一对多
    public function patient()
    {
        return $this->hasMany(PatientModel::class, 'patient_id', 'id');
    }
}
