<?php

namespace Database\Seeders;

use DB;
use Dcat\Admin\Models;
use Illuminate\Database\Seeder;

class AdminTablesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // base tables
        Models\Menu::truncate();
        Models\Menu::insert(
            [
                [
                    'id' => 1,
                    'parent_id' => 0,
                    'order' => 1,
                    'title' => '首页',
                    'icon' => 'feather icon-bar-chart-2',
                    'uri' => '/',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-03 23:16:45',
                ],
                [
                    'id' => 2,
                    'parent_id' => 0,
                    'order' => 28,
                    'title' => '权限管理',
                    'icon' => 'feather icon-settings',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 3,
                    'parent_id' => 2,
                    'order' => 29,
                    'title' => '管理员',
                    'icon' => null,
                    'uri' => 'auth/users',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 4,
                    'parent_id' => 2,
                    'order' => 30,
                    'title' => '角色',
                    'icon' => null,
                    'uri' => 'auth/roles',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 5,
                    'parent_id' => 2,
                    'order' => 31,
                    'title' => '权限',
                    'icon' => null,
                    'uri' => 'auth/permissions',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 6,
                    'parent_id' => 2,
                    'order' => 32,
                    'title' => '菜单',
                    'icon' => null,
                    'uri' => 'auth/menu',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 7,
                    'parent_id' => 2,
                    'order' => 33,
                    'title' => '扩展',
                    'icon' => null,
                    'uri' => 'auth/extensions',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 8,
                    'parent_id' => 2,
                    'order' => 34,
                    'title' => '操作日志',
                    'icon' => 'fa-500px',
                    'uri' => 'auth/operation-logs',
                    'extension' => 'dcat-admin.operation-log',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 9,
                    'parent_id' => 0,
                    'order' => 2,
                    'title' => '药品',
                    'icon' => 'fa-delicious',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:31:50',
                    'updated_at' => '2024-11-06 16:18:28',
                ],
                [
                    'id' => 10,
                    'parent_id' => 9,
                    'order' => 3,
                    'title' => '诊断',
                    'icon' => null,
                    'uri' => 'diagnosi',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:32:12',
                    'updated_at' => '2024-11-04 13:47:23',
                ],
                [
                    'id' => 11,
                    'parent_id' => 9,
                    'order' => 4,
                    'title' => '药品池',
                    'icon' => null,
                    'uri' => 'drug',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:32:28',
                    'updated_at' => '2024-11-06 16:18:45',
                ],
                [
                    'id' => 12,
                    'parent_id' => 0,
                    'order' => 6,
                    'title' => '问诊',
                    'icon' => 'fa-adjust',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:32:49',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 13,
                    'parent_id' => 12,
                    'order' => 7,
                    'title' => '问诊人列表',
                    'icon' => null,
                    'uri' => 'patient',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:08',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 14,
                    'parent_id' => 12,
                    'order' => 8,
                    'title' => '问诊问题',
                    'icon' => null,
                    'uri' => 'inquiry',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:19',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 15,
                    'parent_id' => 0,
                    'order' => 9,
                    'title' => '医师',
                    'icon' => 'fa-shirtsinbulk',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:46',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 16,
                    'parent_id' => 15,
                    'order' => 10,
                    'title' => '医师列表',
                    'icon' => null,
                    'uri' => 'doctor',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:58',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 17,
                    'parent_id' => 0,
                    'order' => 12,
                    'title' => '药店',
                    'icon' => 'fa-bank',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:19',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 18,
                    'parent_id' => 17,
                    'order' => 13,
                    'title' => '药店列表',
                    'icon' => null,
                    'uri' => 'pharmacy',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:31',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 19,
                    'parent_id' => 17,
                    'order' => 14,
                    'title' => '药师列表',
                    'icon' => null,
                    'uri' => 'pharmacist',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:38',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 20,
                    'parent_id' => 0,
                    'order' => 16,
                    'title' => '处方',
                    'icon' => 'fa-address-card-o',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:48',
                    'updated_at' => '2024-11-06 16:21:16',
                ],
                [
                    'id' => 21,
                    'parent_id' => 20,
                    'order' => 17,
                    'title' => '处方列表',
                    'icon' => null,
                    'uri' => 'prescription',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:59',
                    'updated_at' => '2024-11-10 23:37:51',
                ],
                [
                    'id' => 22,
                    'parent_id' => 20,
                    'order' => 18,
                    'title' => '处方日志',
                    'icon' => null,
                    'uri' => 'prescription-log',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:35:09',
                    'updated_at' => '2024-11-10 23:37:59',
                ],
                [
                    'id' => 23,
                    'parent_id' => 0,
                    'order' => 21,
                    'title' => '药品管理',
                    'icon' => 'fa-book',
                    'uri' => 'pharmacy-drug',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:38:11',
                    'updated_at' => '2024-11-11 00:37:44',
                ],
                [
                    'id' => 25,
                    'parent_id' => 0,
                    'order' => 23,
                    'title' => '用法用量',
                    'icon' => 'fa-briefcase',
                    'uri' => 'dosage',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:38:57',
                    'updated_at' => '2024-11-11 00:38:00',
                ],
                [
                    'id' => 27,
                    'parent_id' => 0,
                    'order' => 25,
                    'title' => '处方打印',
                    'icon' => 'fa-print',
                    'uri' => 'prescription-print',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:39:30',
                    'updated_at' => '2024-11-11 07:33:27',
                ],
                [
                    'id' => 29,
                    'parent_id' => 9,
                    'order' => 5,
                    'title' => '药品标签',
                    'icon' => null,
                    'uri' => 'drug-tag',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:18:58',
                    'updated_at' => '2024-11-11 15:28:17',
                ],
                [
                    'id' => 30,
                    'parent_id' => 15,
                    'order' => 11,
                    'title' => '医师纠错',
                    'icon' => null,
                    'uri' => 'doctor-correction',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:19:46',
                    'updated_at' => '2024-11-10 16:22:24',
                ],
                [
                    'id' => 31,
                    'parent_id' => 17,
                    'order' => 15,
                    'title' => '药店纠错',
                    'icon' => null,
                    'uri' => 'pharmacy-correction',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:20:36',
                    'updated_at' => '2024-11-10 16:22:34',
                ],
                [
                    'id' => 32,
                    'parent_id' => 0,
                    'order' => 19,
                    'title' => '系统',
                    'icon' => 'fa-keyboard-o',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:21:08',
                    'updated_at' => '2024-11-06 16:23:42',
                ],
                [
                    'id' => 34,
                    'parent_id' => 32,
                    'order' => 20,
                    'title' => '设置',
                    'icon' => null,
                    'uri' => 'site-config',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:23:54',
                    'updated_at' => '2024-11-10 23:38:06',
                ],
                [
                    'id' => 35,
                    'parent_id' => 9,
                    'order' => 35,
                    'title' => '药品单位',
                    'icon' => null,
                    'uri' => 'drug-unit',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-13 21:18:24',
                    'updated_at' => '2024-11-13 21:18:24',
                ],
            ]
        );

        Models\Permission::truncate();
        Models\Permission::insert(
            [
                [
                    'id' => 1,
                    'name' => '权限管理',
                    'slug' => 'auth-management',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 24,
                    'parent_id' => 0,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 2,
                    'name' => '管理员',
                    'slug' => 'users',
                    'http_method' => '',
                    'http_path' => '/auth/users*',
                    'order' => 25,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 3,
                    'name' => '角色',
                    'slug' => 'roles',
                    'http_method' => '',
                    'http_path' => '/auth/roles*',
                    'order' => 26,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 4,
                    'name' => '权限',
                    'slug' => 'permissions',
                    'http_method' => '',
                    'http_path' => '/auth/permissions*',
                    'order' => 27,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 5,
                    'name' => '菜单',
                    'slug' => 'menu',
                    'http_method' => '',
                    'http_path' => '/auth/menu*',
                    'order' => 28,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 6,
                    'name' => '扩展',
                    'slug' => 'extension',
                    'http_method' => '',
                    'http_path' => '/auth/extensions*',
                    'order' => 29,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 7,
                    'name' => '操作日志',
                    'slug' => 'auth.operationlog',
                    'http_method' => '',
                    'http_path' => 'auth/operation-logs*',
                    'order' => 30,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 23:20:09',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 8,
                    'name' => '药品',
                    'slug' => 'yaopin',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 1,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:26:09',
                    'updated_at' => '2024-11-13 22:34:40',
                ],
                [
                    'id' => 9,
                    'name' => '诊断',
                    'slug' => 'diagnosi',
                    'http_method' => '',
                    'http_path' => 'diagnosi*',
                    'order' => 2,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:26:58',
                    'updated_at' => '2024-11-13 22:35:02',
                ],
                [
                    'id' => 10,
                    'name' => '药品池',
                    'slug' => 'drug',
                    'http_method' => '',
                    'http_path' => 'drug*',
                    'order' => 3,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:27:21',
                    'updated_at' => '2024-11-13 22:35:07',
                ],
                [
                    'id' => 11,
                    'name' => '药品标签',
                    'slug' => 'drug-tag',
                    'http_method' => '',
                    'http_path' => 'drug-tag*',
                    'order' => 4,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:27:59',
                    'updated_at' => '2024-11-13 22:35:22',
                ],
                [
                    'id' => 12,
                    'name' => '药品单位',
                    'slug' => 'drug-unit',
                    'http_method' => '',
                    'http_path' => 'drug-unit*',
                    'order' => 5,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:28:23',
                    'updated_at' => '2024-11-13 22:35:27',
                ],
                [
                    'id' => 13,
                    'name' => '问诊',
                    'slug' => 'wenzhen',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 6,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:29:16',
                    'updated_at' => '2024-11-13 22:35:35',
                ],
                [
                    'id' => 14,
                    'name' => '问诊人列表',
                    'slug' => 'patient',
                    'http_method' => '',
                    'http_path' => 'patient*',
                    'order' => 7,
                    'parent_id' => 13,
                    'created_at' => '2024-11-13 22:29:50',
                    'updated_at' => '2024-11-13 22:35:49',
                ],
                [
                    'id' => 15,
                    'name' => '问诊问题',
                    'slug' => 'inquiry',
                    'http_method' => '',
                    'http_path' => 'inquiry*',
                    'order' => 8,
                    'parent_id' => 13,
                    'created_at' => '2024-11-13 22:30:20',
                    'updated_at' => '2024-11-13 22:35:57',
                ],
                [
                    'id' => 16,
                    'name' => '医师',
                    'slug' => 'yishi',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 9,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:30:40',
                    'updated_at' => '2024-11-13 22:36:03',
                ],
                [
                    'id' => 17,
                    'name' => '医师列表',
                    'slug' => 'doctor',
                    'http_method' => '',
                    'http_path' => 'doctor*',
                    'order' => 10,
                    'parent_id' => 16,
                    'created_at' => '2024-11-13 22:31:09',
                    'updated_at' => '2024-11-13 22:36:08',
                ],
                [
                    'id' => 18,
                    'name' => '医师纠错',
                    'slug' => 'doctor-correction',
                    'http_method' => '',
                    'http_path' => 'doctor-correction*',
                    'order' => 11,
                    'parent_id' => 16,
                    'created_at' => '2024-11-13 22:31:37',
                    'updated_at' => '2024-11-13 22:36:14',
                ],
                [
                    'id' => 19,
                    'name' => '药店',
                    'slug' => 'yaodian',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 12,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:31:59',
                    'updated_at' => '2024-11-13 22:36:19',
                ],
                [
                    'id' => 20,
                    'name' => '药店列表',
                    'slug' => 'pharmacy',
                    'http_method' => '',
                    'http_path' => 'pharmacy*',
                    'order' => 13,
                    'parent_id' => 19,
                    'created_at' => '2024-11-13 22:32:31',
                    'updated_at' => '2024-11-13 22:36:25',
                ],
                [
                    'id' => 21,
                    'name' => '药师列表',
                    'slug' => 'pharmacist',
                    'http_method' => '',
                    'http_path' => 'pharmacist*',
                    'order' => 14,
                    'parent_id' => 19,
                    'created_at' => '2024-11-13 22:33:02',
                    'updated_at' => '2024-11-13 22:33:57',
                ],
                [
                    'id' => 22,
                    'name' => '药店纠错',
                    'slug' => 'pharmacy-correction',
                    'http_method' => '',
                    'http_path' => 'pharmacy-correction*',
                    'order' => 15,
                    'parent_id' => 19,
                    'created_at' => '2024-11-13 22:33:54',
                    'updated_at' => '2024-11-13 22:36:34',
                ],
                [
                    'id' => 23,
                    'name' => '处方',
                    'slug' => 'chufang',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 16,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:34:24',
                    'updated_at' => '2024-11-13 22:36:50',
                ],
                [
                    'id' => 24,
                    'name' => '处方列表',
                    'slug' => 'prescription',
                    'http_method' => '',
                    'http_path' => 'prescription*',
                    'order' => 17,
                    'parent_id' => 23,
                    'created_at' => '2024-11-13 22:37:11',
                    'updated_at' => '2024-11-13 22:37:56',
                ],
                [
                    'id' => 25,
                    'name' => '处方日志',
                    'slug' => 'prescription-log',
                    'http_method' => '',
                    'http_path' => 'prescription-log*',
                    'order' => 18,
                    'parent_id' => 23,
                    'created_at' => '2024-11-13 22:37:30',
                    'updated_at' => '2024-11-13 22:37:56',
                ],
                [
                    'id' => 26,
                    'name' => '系统',
                    'slug' => 'xitong',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 19,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:37:52',
                    'updated_at' => '2024-11-13 22:37:56',
                ],
                [
                    'id' => 27,
                    'name' => '设置',
                    'slug' => 'site-config',
                    'http_method' => '',
                    'http_path' => 'site-config*',
                    'order' => 20,
                    'parent_id' => 26,
                    'created_at' => '2024-11-13 22:38:16',
                    'updated_at' => '2024-11-13 22:39:33',
                ],
                [
                    'id' => 28,
                    'name' => '药品管理[药店]',
                    'slug' => 'pharmacy-drug',
                    'http_method' => '',
                    'http_path' => 'pharmacy-drug*',
                    'order' => 21,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:38:49',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 29,
                    'name' => '用法用量[药店]',
                    'slug' => 'dosage',
                    'http_method' => '',
                    'http_path' => 'dosage*',
                    'order' => 22,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:39:14',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 30,
                    'name' => '处方打印[药店]',
                    'slug' => 'prescription-print',
                    'http_method' => '',
                    'http_path' => 'prescription-print*',
                    'order' => 23,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:39:31',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
            ]
        );

        Models\Role::truncate();
        Models\Role::insert(
            [
                [
                    'id' => 1,
                    'name' => 'Administrator',
                    'slug' => 'administrator',
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-03 02:13:11',
                ],
                [
                    'id' => 2,
                    'name' => '药店管理员',
                    'slug' => 'pharmacy',
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'id' => 3,
                    'name' => '同知堂管理员',
                    'slug' => 'tzt.administrator',
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:45:18',
                ],
            ]
        );

        Models\Setting::truncate();
        Models\Setting::insert(
            [
                [
                    'slug' => 'guanguans:dcat-login-captcha',
                    'value' => '{"length":4,"charset":"abcdefghijklmnpqrstuvwxyz23456789ABCDEFGHIJKLMNOPQRSTUVWXYZ","width":150,"height":43,"type":"png","font":null,"fingerprint":null,"captcha_phrase_session_key":"login_captcha_phrase"}',
                    'created_at' => '2024-11-03 02:13:44',
                    'updated_at' => '2024-11-03 02:13:44',
                ],
            ]
        );

        Models\Extension::truncate();
        Models\Extension::insert(
            [
                [
                    'id' => 1,
                    'name' => 'dcat-admin.operation-log',
                    'version' => '1.0.0',
                    'is_enabled' => 1,
                    'options' => null,
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-03 02:13:45',
                ],
                [
                    'id' => 2,
                    'name' => 'guanguans.dcat-login-captcha',
                    'version' => '1.1.0',
                    'is_enabled' => 1,
                    'options' => null,
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:44',
                ],
                [
                    'id' => 3,
                    'name' => 'sparkinzy.dcat-viewer',
                    'version' => '1.0.3',
                    'is_enabled' => 1,
                    'options' => null,
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:43',
                ],
            ]
        );

        Models\ExtensionHistory::truncate();
        Models\ExtensionHistory::insert(
            [
                [
                    'id' => 1,
                    'name' => 'dcat-admin.operation-log',
                    'type' => 2,
                    'version' => '1.0.0',
                    'detail' => 'create_opration_log_table.php',
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-03 02:13:40',
                ],
                [
                    'id' => 2,
                    'name' => 'dcat-admin.operation-log',
                    'type' => 1,
                    'version' => '1.0.0',
                    'detail' => 'Initialize extension.',
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-03 02:13:40',
                ],
                [
                    'id' => 3,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.0',
                    'detail' => 'Initial release.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 4,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Add default config file.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 5,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Add annotation for facades.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 6,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Optimize `login_captcha_check` function.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 7,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Optimize captcha generate.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 8,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Optimize get setting config.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 9,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Rename `dcat_login_captcha_check`->`login_captcha_check`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 10,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.1',
                    'detail' => 'Rename `dcat_login_captcha_url`->`login_captcha_url`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 11,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => 'Add login_captcha_get function.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 12,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => 'Update lang files.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 13,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => 'Update extension alias and description.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 14,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => 'Optimize LoginCaptchaServiceProvider.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 15,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => 'Optimize setting form.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 16,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.3',
                    'detail' => 'Add CleanObContents Middleware.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 17,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.4',
                    'detail' => 'Add SetResponseContentType Middleware.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 18,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.4',
                    'detail' => 'Add content type setting config.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 19,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.5',
                    'detail' => 'Add BootingHandler.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 20,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.6',
                    'detail' => 'Rename src/BootingAdmin.php -> src/BootingHandler.php.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 21,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.6',
                    'detail' => 'Remove src/Http/Controllers/CaptchaController.php`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 22,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.7',
                    'detail' => 'Optimize `buildCaptchaJsScript`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 23,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.8',
                    'detail' => 'Fix cant match routing path(#8).',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 24,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.9',
                    'detail' => 'Add parameters to the `SetResponseContentType` middleware.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 25,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.9',
                    'detail' => 'Update github config files.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 26,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.9',
                    'detail' => 'Update phpunit/phpunit requirement from ^7.0 || ^8.0 to ^7.0 || ^8.0 || ^9.0.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 27,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.9',
                    'detail' => 'Optimize booting `BootingHandler`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 28,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.9',
                    'detail' => 'Optimize setting form .',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 29,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.10',
                    'detail' => 'Compatible callback type.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 30,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.11',
                    'detail' => 'Rename `phrase_session_key` -> `captcha_phrase_session_key`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 31,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.11',
                    'detail' => 'Generate captcha random url.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 32,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.11',
                    'detail' => 'Replace `Closure routing` -> `CaptchaController`.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 33,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.11',
                    'detail' => 'Bump actions/cache from 2 to 3.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 34,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.11',
                    'detail' => 'Bump actions/checkout from 2 to 3.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 35,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.11',
                    'detail' => 'Update overtrue/phplint requirement from ^2.3 || ^3.0 to ^2.3 || ^3.0 || ^4.0.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 36,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.12',
                    'detail' => 'Bump codecov/codecov-action from 2.1.0 to 3.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 37,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.12',
                    'detail' => 'Update author info.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 38,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.13',
                    'detail' => 'Update JS.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 39,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.14',
                    'detail' => 'Rename login_captcha_get -> login_captcha_content.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 40,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.14',
                    'detail' => 'Update github config files.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 41,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.15',
                    'detail' => 'Fix captcha check.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 42,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.16',
                    'detail' => 'Add migration files.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 43,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.17',
                    'detail' => 'Fix migration file name.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 44,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.18',
                    'detail' => 'Update to single action controller.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 45,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.18',
                    'detail' => 'Fix setting.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 46,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.18',
                    'detail' => 'Optimize migration file.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 47,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.19',
                    'detail' => 'Fix loading config.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 48,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.19',
                    'detail' => 'Remove version update migration.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 49,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.0.19',
                    'detail' => 'Cancel service late registration.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 50,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'chore(deps): update overtrue/phplint to support more versions.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 51,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'update LoginCaptchaServiceProvider.php to merge config correctly(#27).',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 52,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'Bump dependabot/fetch-metadata from 1.3.5 to 1.3.6.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 53,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'Bump actions/stale from 6 to 7.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 54,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'Update vimeo/psalm requirement from ^4.0 to ^4.0 || ^5.0.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 55,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'Bump dependabot/fetch-metadata from 1.3.4 to 1.3.5.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 56,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'Bump dependabot/fetch-metadata from 1.3.3 to 1.3.4.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 57,
                    'name' => 'guanguans.dcat-login-captcha',
                    'type' => 1,
                    'version' => '1.1.0',
                    'detail' => 'Bump actions/stale from 5 to 6.',
                    'created_at' => '2024-11-03 02:13:41',
                    'updated_at' => '2024-11-03 02:13:41',
                ],
                [
                    'id' => 58,
                    'name' => 'sparkinzy.dcat-viewer',
                    'type' => 1,
                    'version' => '1.0.0',
                    'detail' => '基于 神级插件 viewerjs 做的一个封装，提升Dcat Admin 图片预览效果，实现放大、缩小、翻转、旋转等效果.',
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:42',
                ],
                [
                    'id' => 59,
                    'name' => 'sparkinzy.dcat-viewer',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => '提升viewer的zindex为8个9,方便在modal实现图片预览',
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:42',
                ],
                [
                    'id' => 60,
                    'name' => 'sparkinzy.dcat-viewer',
                    'type' => 1,
                    'version' => '1.0.3',
                    'detail' => '新增views目录，便于php artisan optimize',
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:42',
                ],
            ]
        );

        // pivot tables
        DB::table('admin_permission_menu')->truncate();
        DB::table('admin_permission_menu')->insert(
            [

            ]
        );

        DB::table('admin_role_menu')->truncate();
        DB::table('admin_role_menu')->insert(
            [
                [
                    'role_id' => 1,
                    'menu_id' => 1,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 2,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 3,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 4,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 5,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 6,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 7,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 8,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 9,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 10,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 11,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 12,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 13,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 14,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 15,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 16,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 17,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 18,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 19,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 20,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 21,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 22,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 29,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 30,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 31,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 32,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 34,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 35,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 23,
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 25,
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 27,
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 9,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 10,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 11,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 12,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 13,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 14,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 15,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 16,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 17,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 18,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 19,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 20,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 21,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 22,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 29,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 30,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 31,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 32,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 34,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 35,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
            ]
        );

        DB::table('admin_role_permissions')->truncate();
        DB::table('admin_role_permissions')->insert(
            [
                [
                    'role_id' => 1,
                    'permission_id' => 2,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 3,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 4,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 5,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 6,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 7,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 9,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 10,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 11,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 12,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 14,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 15,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 17,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 18,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 20,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 21,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 22,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 24,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 25,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 27,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 28,
                    'created_at' => '2024-11-13 22:40:14',
                    'updated_at' => '2024-11-13 22:40:14',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 29,
                    'created_at' => '2024-11-13 22:40:14',
                    'updated_at' => '2024-11-13 22:40:14',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 30,
                    'created_at' => '2024-11-13 22:40:14',
                    'updated_at' => '2024-11-13 22:40:14',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 9,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 10,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 11,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 12,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 14,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 15,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 17,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 18,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 20,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 21,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 22,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 24,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 25,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'permission_id' => 27,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
            ]
        );

        // finish
    }
}
